<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserRewardPoint extends Model 
{

    protected $table = 'user_reward_point';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'user_id', 'reward_point', 'reward_type', 'operation_type', 'expire_on');
    protected $visible = array('order_id', 'user_id', 'reward_point', 'reward_type', 'operation_type', 'expire_on');

    public function orders()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function users()
    {
        return $this->belongsTo('User', 'user_id');
    }

}